#ifndef __CSCalWindow__
#define __CSCalWindow__

#include <EGUI.h>
#include <EMusic.h>

namespace Exponent
{
	namespace SCal
	{
		/**
		 * @class CSCalWindow CSCalWindow.hpp
		 * @brief Main SCal Window, where everything happens
		 *
		 * @date 09/09/2006
		 * @author Paul Chana
		 * @version 1.0.0 Initial version
		 *
		 * @note All contents of this source code are copyright 2007 Exp Digital Uk.\n
		 * This file forms part of the example projects for the Infinity API.\n
		 * You may not redistribute either the source code or the compiled binary.\n
		 * The Infinity API is covered by a fair use licence which you should have recieved with this\n
		 * file. If you didnt receieve the licence, please contact us via http://www.expdigital.co.uk
		 *
		 * $Id: CSCalWindow.hpp,v 1.6 2007/02/11 02:20:27 paul Exp $
		 */
		class CSCalWindow : public CWindow
		{
			/** @cond */
			EXPONENT_CLASS_DECLARATION;
			/** @endcond */

//	===========================================================================

		public:

//	===========================================================================

			const static CAlphaColour CSCALWINDOW_TEXT_COLOUR;				/**< Colour of any text box text */
			const static CAlphaColour CSCALWINDOW_ANSWER_TEXT_COLOUR;		/**< Colour of any text box text for answers */
			const static CAlphaColour CSCALWINDOW_BACKGROUND_COLOUR;		/**< Background edit colour */
			static SMenuColours CSCALWINDOW_MENU_COLOURS;					/**< The menu colours to be used by the window */
			static CWindowAttributes CSCALWINDOW_MENU_WINDOW_ATTRIBUTES;	/**< Default menu window attributes */

			const static CRect CSCALWINDOW_CONTROL1_RECT;					/**< Area of control 1 */
			const static CRect CSCALWINDOW_CONTROL2_RECT;					/**< Area of control 2 */
			const static CRect CSCALWINDOW_OUTPUTBOX_RECT;					/**< Area of output */

//	===========================================================================

			/**
			 * Construction
			 * @param size The size of the window
			 */
			CSCalWindow(const CRect &size);

			/**
			 * Destruction
			 */
			virtual ~CSCalWindow();

//	===========================================================================

		protected:

//	===========================================================================

			TAutomaticPointer<CMenu> m_divisionMenu;				/**< Division menu */
		};
	}
}
#endif		// End of CSCalWindow.hpp